# 🗃️ Catalogador -  DCAT-BR

[![Python](https://img.shields.io/badge/Python-3.8%2B-blue?logo=python)](https://www.python.org/)
[![Flask](https://img.shields.io/badge/Flask-3.0-blue?logo=flask)](https://flask.palletsprojects.com/)
[![License](https://img.shields.io/badge/License-MIT-green)](LICENSE)

Aplicação web para catalogação de conjuntos de dados governamentais brasileiros seguindo o padrão **DCAT-BR**, com geração automática de metadados no padrão DCAT-BR.

![Interface Preview](https://www.gov.br/governodigital/pt-br/infraestrutura-nacional-de-dados/catalogo-nacional-de-dados/catalogo_nacional_de_dados/@@govbr.institucional.banner/b1aa34c9-9395-41d2-8978-21ebb141e44b/@@images/9c458d27-e88b-4978-bd57-b4f5c38880fb.png)

## 📝 Acessar solução 

- [Cataloador - DCAT-BR](https://www.gov.br/governodigital/pt-br/infraestrutura-nacional-de-dados/catalogo-nacional-de-dados)

## ✨ Funcionalidades

- ✅ Formulário web alinhado com o padrão de identidade visual gov.br
- 🚀 Geração automática de RDF/XML
- 🔍 Validação de campos obrigatórios
- 📦 Exportação em padrão DCAT-BR Bronze
- 🌐 Suporte a URIs e vocabulários controlados

## ⚡ Instalação Rápida

### Pré-requisitos
- Python 3.8+
- pip
- Git (opcional)

### Passo a Passo

**Clonar o repositório**:
```bash
git clone https://github.com/seu-usuario/dcat-br-catalogador.git
cd dcat-br-catalogador
```

**Criar ambiente virtual:**:
```bash
python -m venv venv-dcat-br-catalogado
```

**Ativar ambiente virtual:**
```bash
# Windows
.\venv-dcat-br-catalogado\Scripts\activate

# Linux/Mac
source venv-dcat-br-catalogador/bin/activate
```

**Instalar dependências:**:
```bash
pip install -r requirements.txt
```

**Executar aplicação:**:
```bash
python app.py
```

**Acessar interface:**:
```bash
http://localhost:5000
```

**🗂️ Estrutura do Projeto:**:
```bash
dcat-br-catalogador/
├── app.py
├── templates/
│   └── form.html
├── requirements.txt
├── README.md
└── venv-dcat-br-catalogador/               # Gerado automaticamente
```

## ⚡ Como Utilizar

- Preencha todos os campos obrigatórios marcados com *;
- Para campos URI, utilize endereços válidos (ex: http://creativecommons.org/licenses/by/4.0/);
- Separe múltiplos valores (como palavras-chave) por vírgulas;
- Clique em "Gerar RDF" para exportar o arquivo de metadados.

## 🤝 Como Contribuir

- Faça um fork do projeto;
- Crie uma branch para sua feature:

**Feature**:
```bash
git checkout -b feature/nova-feature
```

**Commit suas mudanças**:
```bash
git commit -m 'Adiciona nova funcionalidade'
```

**Push para a branch:**:
```bash
git push origin feature/nova-feature
```

**Abra um Pull Request**:

## 📄 Licença

- Este projeto está licenciado sob a Licença MIT.

## 🌐 Recursos Oficiais

- Documentação DCAT-BR
- Padrão de Identidade Digital gov.br
- W3C DCAT


## 👥 Reconhecimentos

- W3C DCAT


